import { isMouseEvent } from './utils/event-type.mjs';
import { AnimationType } from '../render/utils/types.mjs';
import { usePointerEvent } from '../events/use-pointer-event.mjs';
import { isDragActive } from './drag/utils/lock.mjs';

function createHoverEvent(visualElement, isActive, callback) {
    return (event, info) => {
        if (!isMouseEvent(event) || isDragActive())
            return;
        /**
         * Ensure we trigger animations before firing event callback
         */
        if (visualElement.animationState) {
            visualElement.animationState.setActive(AnimationType.Hover, isActive);
        }
        callback && callback(event, info);
    };
}
function useHoverGesture({ onHoverStart, onHoverEnd, whileHover, visualElement, }) {
    usePointerEvent(visualElement, "pointerenter", onHoverStart || whileHover
        ? createHoverEvent(visualElement, true, onHoverStart)
        : undefined, { passive: !onHoverStart });
    usePointerEvent(visualElement, "pointerleave", onHoverEnd || whileHover
        ? createHoverEvent(visualElement, false, onHoverEnd)
        : undefined, { passive: !onHoverEnd });
}

export { useHoverGesture };
